clearvars

fig = figure
load d10K50s2Gaussian.mat
cap = 4;
formatSpec = '%.2f';

t = tiledlayout(3,2,'TileSpacing','Compact', 'Padding', 'Compact');
ax = nexttile
%subplot(2, 2, 1)
line1 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'Marker', 'diamond', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'Marker', 'pentagram')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, 'm', 'Marker', '*')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, '-.g', 'Marker', '>')
semilogx(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, '-.b', 'Marker', '|')
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-r', 'Marker', 'square')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, 'g', 'Marker', 'o')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, 'c', 'Marker', 'x')
hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, std_prob_error_Lasso_XY, 'm', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, std_prob_error_Lasso_Bayes, 'g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, std_prob_error_PopArt_OD, 'b', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

%clearvars
cap = 4;

load d20K50s2Gaussian.mat
ax = nexttile
line2 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'Marker', 'diamond', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'Marker', 'pentagram')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, 'm', 'Marker', '*')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, '-.g', 'Marker', '>')
semilogx(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, '-.b', 'Marker', '|')
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-r', 'Marker', 'square')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, 'g', 'Marker', 'o')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, 'c', 'Marker', 'x')
hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, std_prob_error_Lasso_XY, 'm', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, std_prob_error_Lasso_Bayes, 'g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, std_prob_error_PopArt_OD, 'b', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

%clearvars
cap = 4;

load d10K50s3Gaussian.mat
ax = nexttile
line3 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'Marker', 'diamond', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'Marker', 'pentagram')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, 'm', 'Marker', '*')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, '-.g', 'Marker', '>')
semilogx(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, '-.b', 'Marker', '|')
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-r', 'Marker', 'square')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, 'g', 'Marker', 'o')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, 'c', 'Marker', 'x')
hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, std_prob_error_Lasso_XY, 'm', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, std_prob_error_Lasso_Bayes, 'g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, std_prob_error_PopArt_OD, 'b', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

%clearvars
cap = 4;

load d20K50s3Gaussian.mat
ax = nexttile
line4 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'Marker', 'diamond', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'Marker', 'pentagram')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, 'm', 'Marker', '*')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, '-.g', 'Marker', '>')
semilogx(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, '-.b', 'Marker', '|')
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-r', 'Marker', 'square')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, 'g', 'Marker', 'o')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, 'c', 'Marker', 'x')
hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, std_prob_error_Lasso_XY, 'm', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, std_prob_error_Lasso_Bayes, 'g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, std_prob_error_PopArt_OD, 'b', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

%clearvars
cap = 4;

load d10K50s4Gaussian.mat
ax = nexttile
line4 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'Marker', 'diamond', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'Marker', 'pentagram')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, 'm', 'Marker', '*')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, '-.g', 'Marker', '>')
semilogx(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, '-.b', 'Marker', '|')
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-r', 'Marker', 'square')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, 'g', 'Marker', 'o')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, 'c', 'Marker', 'x')
hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, std_prob_error_Lasso_XY, 'm', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, std_prob_error_Lasso_Bayes, 'g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, std_prob_error_PopArt_OD, 'b', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

%clearvars
cap = 4;

load d20K50s4Gaussian.mat
ax = nexttile
line4 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'Marker', 'diamond', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'Marker', 'pentagram')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, 'm', 'Marker', '*')
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, '-.g', 'Marker', '>')
semilogx(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, '-.b', 'Marker', '|')
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-r', 'Marker', 'square')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, 'g', 'Marker', 'o')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, 'c', 'Marker', 'x')

hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_XY, std_prob_error_Lasso_XY, 'm', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_Bayes, std_prob_error_Lasso_Bayes, 'g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_PopArt_OD, std_prob_error_PopArt_OD, 'b', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

lg = legend(ax, 'Lasso-OD', 'Lasso-OD-Analytical', 'Lasso-XY', 'Lasso-BayesGap', 'PopArt-OD', 'OD-LinBAI', 'BayesGap-Adaptive', 'GSE', 'Box', 'off', 'NumColumns', 5)
lg.Layout.Tile = 'South';

ax = gca;
outerpos = ax.OuterPosition;
ti = ax.TightInset; 
left = outerpos(1) + ti(1);
bottom = outerpos(2) + ti(2);
ax_width = outerpos(3) - ti(1) - ti(3);
ax_height = outerpos(4) - ti(2) - ti(4);
ax.Position = [left bottom ax_width ax_height];
